The BoTorch website was created with [Docusaurus](https://docusaurus.io/).
FontAwesome icons were used under the
[Creative Commons Attribution 4.0 International](https://fontawesome.com/license).

## Building

You need [Node](https://nodejs.org/en/) >= 8.x and
[Yarn](https://yarnpkg.com/en/) >= 1.5 in order to build the botorch website.

Switch to the `website` dir from the project root and start the server:
```bash
cd website
yarn
yarn start
```

Open http://localhost:3000 (if doesn't automatically open).

Anytime you change the contents of the page, the page should auto-update.

Note that the above does not re-build the API reference (auto-generated by
Sphinx) or parse and embed the tutorial notebooks. If you're looking for a
one-stop shop that does all of this, you can run the following:
```bash
./scripts/build_docs.sh
```

#### Generating a static build

To generate a static build of the website in the `website/build` directory, run
```bash
./scripts/build_docs.sh -b
```

## Publishing

The site is hosted on GitHub pages, via the `gh-pages` branch of the BoTorch
[GitHub repo](https://github.com/pytorch/botorch/tree/gh-pages).
The website is automatically built and published from GitHub Actions - see the
[config file](https://github.com/pytorch/botorch/blob/main/.github/workflows/nightly.yml)
for the nightly build job for details.
